<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<fieldset>
	<legend><?php echo vmText::_('COM_VIRTUEMART_VENDOR_FORM_INFO_LBL') ?></legend>
	<div class="form-group">
		<label class="control-label col-sm-3" for="vendor_store_name"><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_STORE_NAME'); ?></label>
		<div class="col-sm-9">
			<input class="form-control" type="text" name="vendor_store_name" id="vendor_store_name" size="50" value="<?php echo $this->vendor->vendor_store_name; ?>"/>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-sm-3" for="vendor_name"><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_COMPANY_NAME'); ?></label>
		<div class="col-sm-9">
			<input class="form-control" type="text" name="vendor_name" id="vendor_name" size="50" value="<?php echo $this->vendor->vendor_name; ?>"/>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-sm-3" for="vendor_url"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_URL'); ?></label>
		<div class="col-sm-9">
			<input class="form-control" type="url" name="vendor_url" id="vendor_url" size="50" value="<?php echo $this->vendor->vendor_url; ?>"/>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-sm-3" for="vendor_min_pov"><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_MPOV'); ?></label>
		<div class="col-sm-9">
			<input class="form-control" type="text" name="vendor_min_pov" id="vendor_min_pov" size="10" value="<?php echo $this->vendor->vendor_min_pov; ?>"/>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-sm-3" for="virtuemart_currency_id"><?php echo vmText::_('COM_VIRTUEMART_CURRENCY'); ?></label>
		<div class="col-sm-9">
			<?php echo JHtml::_('select.genericlist', $this->currencies, 'vendor_currency', 'class="form-control vm-chzn-select"', 'virtuemart_currency_id', 'currency_name', $this->vendor->vendor_currency); ?>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-sm-3" for="vendor_accepted_currencies"><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_ACCEPTED_CURRENCIES'); ?></label>
		<div class="col-sm-9">
			<?php echo JHtml::_('select.genericlist', $this->currencies, 'vendor_accepted_currencies[]', 'size=10 multiple="multiple" class="form-control vm-chzn-select"', 'virtuemart_currency_id', 'currency_name', $this->vendor->vendor_accepted_currencies); ?>
		</div>
	</div>		
</fieldset>
<div id="vm-vendor-image-area">
	<?php echo $this->vendor->images[0]->displayFilesHandler($this->vendor->virtuemart_media_id, 'vendor'); ?>
</div>
<fieldset>
	<legend><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_DESCRIPTION'); ?></legend>
	<?php echo $this->editor->display('vendor_store_desc', $this->vendor->vendor_store_desc, '100%', 450, 70, 15); ?>
</fieldset>
<fieldset>
	<legend><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_TOS'); ?></legend>
	<?php echo $this->editor->display('vendor_terms_of_service', $this->vendor->vendor_terms_of_service, '100%', 450, 70, 15); ?>
</fieldset>
<fieldset>
	<legend><?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_LEGAL'); ?></legend>
	<?php echo $this->editor->display('vendor_legal_info', $this->vendor->vendor_legal_info, '100%', 400, 70, 15); ?>
</fieldset>

<input type="hidden" name="user_is_vendor" value="1"/>
<input type="hidden" name="virtuemart_vendor_id" value="<?php echo $this->vendor->virtuemart_vendor_id; ?>"/>
<input type="hidden" name="last_task" value="<?php echo vRequest::getCmd('task'); ?>"/>