<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
?>
<fieldset class="vmshopper-set">
	<legend><?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_LBL') ?></legend>
	<?php	if(Vmconfig::get('multix', 'none') !== 'none') : ?>
		<div class="form-group">
			<label for="virtuemart_vendor_id" class="control-label col-sm-3"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_VENDOR') ?></label>
			<div class="col-sm-9">
				<?php echo $this->lists['vendors']; ?>
			</div>
		</div>
	<?php endif; ?>
	<div class="form-group">
		<label for="customer_number" class="control-label col-sm-3"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_CUSTOMER_NUMBER') ?></label>
		<div class="col-sm-9">
			<?php if(JFactory::getUser()->authorise('core.admin', 'com_virtuemart')) : ?>
				<input type="text" class="form-control" name="customer_number" id="customer_number" size="40" value="<?php echo $this->lists['custnumber'];?>"/>
			<?php else : ?>
				<input type="text" class="form-control" name="customer_number" id="customer_number" size="40" value="<?php echo $this->lists['custnumber'];?>" disabled="disabled"/>
			<?php endif; ?>
		</div>
	</div>
	<?php if($this->lists['shoppergroups']) : ?>
		<div class="form-group">
			<label for="virtuemart_shoppergroup_id" class="control-label col-sm-3"><?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_GROUP') ?></label>
			<div class="col-sm-9">
				<?php echo $this->lists['shoppergroups']; ?>
			</div>
		</div>	
	<?php endif; ?>
</fieldset>
