<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

$template = plgSystemVPFrameworkHelper::getTemplate();

$min = VmConfig::get('asks_minimum_comment_length', 50);
$max = VmConfig::get('asks_maximum_comment_length', 2000);
vmJsApi::JvalideForm();
vmJsApi::addJScript('askform', '
  jQuery(function($){
    $("#askform").validationEngine("attach");
    $("#comment").keyup( function () {
      var result = $(this).val();
      $("#counter").val( result.length );
    });
  });
');
?>
<section class="vendor-contact-view">
	<div class="page-header">
		<h1><?php echo $this->vendor->vendor_store_name ?></h1>
	</div>
	<div class="vendor-address well">
		<div class="row row-condensed">
			<div class="col-sm-7">
				<?php echo shopFunctionsF::renderVendorAddress($this->vendor->virtuemart_vendor_id); ?>
			</div>
			<div class="col-sm-5">
				<?php if(!empty($this->vendor->images[0])) : ?>
					<?php echo $this->vendor->images[0]->displayMediaThumb('class="img-responsive"', false); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<div class="vendor-contact-form">
		<form method="post" class="form-validate" action="<?php echo JRoute::_('index.php') ; ?>" name="askform" id="askform">
			<fieldset>
				<legend><?php echo vmText::_('COM_VIRTUEMART_VENDOR_ASK_QUESTION') ?></legend>
				<div class="form-group">
					<label for="name" class="control-label"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_NAME') ?></label>
					<input type="text" class="form-control validate[required,minSize[4],maxSize[64]]" value="<?php echo $this->user->name ?>" name="name" id="name" size="30" validation="required name" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USER_FORM_NAME') ?>"/>
				</div>
				<div class="form-group">
					<label for="email" class="control-label"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EMAIL') ?></label>
					<input type="text" class="form-control validate[required,custom[email]]" value="<?php echo $this->user->email ?>" name="email" id="email" size="30" validation="required email" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EMAIL') ?>"/>
				</div>
				<div class="form-group">
					<label for="email" class="control-label"><?php echo vmText::sprintf('COM_VIRTUEMART_ASK_COMMENT', $min, $max) ?></label>
					<textarea class="form-control validate[required,minSize[<?php echo $min ?>],maxSize[<?php echo $max ?>]] field" id="comment" name="comment" cols="30" rows="10"></textarea>
				</div>
				<div class="form-group group-inline">
					<label for="counter"><?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT') ?></label>
					<input type="text" value="0" size="4" class="form-control" id="counter" name="counter" maxlength="4" readonly="readonly" />						
				</div>
				<?php if(VmConfig::get ('ask_captcha')) : ?>
					<div class="form-group">
						<label for="captcha" class="sr-only"><?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT') ?></label>
						<?php echo $template->getCaptchaField() ?>
					</div>
				<?php endif; ?>
				<div class="form-submit-cont">
					<button class="btn btn-base btn-lg" type="submit" name="submit_ask" title="<?php echo vmText::_('COM_VIRTUEMART_ASK_SUBMIT') ?>"><?php echo vmText::_('COM_VIRTUEMART_ASK_SUBMIT')  ?></button>
				</div>			
			</fieldset>
			<input type="hidden" name="view" value="vendor"/>
			<input type="hidden" name="virtuemart_vendor_id" value="<?php echo $this->vendor->virtuemart_vendor_id ?>"/>
			<input type="hidden" name="option" value="com_virtuemart"/>
			<input type="hidden" name="task" value="mailAskquestion"/>
			<?php echo JHtml::_('form.token'); ?>			
		</form>
	</div>
	<div class="vendor-page-links">
		<ul class="list-inline">
			<li>
				<?php echo $this->linkdetails ?>
			</li>
			<li>
				<?php echo $this->linktos ?>
			</li>
		</ul>
	</div>	
</section>