<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');
?>
<?php echo $this->add_product_link; ?>

<?php if(!empty($this->vendor->vendor_store_desc) && VmConfig::get('show_store_desc', 1)) : ?>
<div class="vendor-store-desc">
	<?php echo $this->vendor->vendor_store_desc; ?>
</div>
<?php endif; ?>

<?php if($this->categories && VmConfig::get('show_categories', 1)) : ?>
	<section class="vm-frontpage-view categories">
		<?php echo $this->renderVmSubLayout('categories', array('categories' => $this->categories)); ?>
	</section>
<?php endif; ?>

<?php
# Show template for : topten, Featured, Latest Products if selected in config BE
if(!empty($this->products))
{
	$products_per_row = VmConfig::get('homepage_products_per_row', 3);
	
	foreach($this->products as $type => $products)
	{
		if(!empty($products)) : ?>
			<section class="vm-frontpage-view <?php echo $type ?>">
				<h3><?php echo vmText::_('COM_VIRTUEMART_'.strtoupper($type).'_PRODUCT'); ?></h3>
				<?php
				$viewData = array('products' => $products, 'currency' => $this->currency, 'products_per_row' => $products_per_row, 'showRating' => $this->showRating);
				echo $this->renderVmSubLayout($this->productsLayout, $viewData);
				?>
			</section>
		<?php endif;
	}
}
?>