<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die('Restricted access');

vmJsApi::jPrice();
?>
<div class="wishlist-page">
	<ul class="table-list">
		<?php if(empty($this->wproducts)) : ?>
			<li>
				<p class="empty-list"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_EMPTY') ?></p>
			</li>
		<?php else : ?>
			<?php foreach($this->wproducts as $product) : ?>
				<li class="product-item">
					<dl>
						<dt class="width15">
							<?php if(!empty($product->images[0])) : ?>
								<a href="<?php echo $product->link ?>" title="<?php echo $product->product_name ?>">
									<?php echo $product->images[0]->displayMediaThumb ('class="responsive-image"', false); ?>
								</a>
							<?php endif; ?>
						</dt>
						<dd>
							<div class="product-name">
								<a href="<?php echo $product->link ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
							</div>
							<div class="hidden-xs">
								<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $this->show_rating, 'product' => $product)); ?>
							</div>
							<?php if(!empty($product->product_s_desc)) : ?>
								<div class="product-s-desc">
									<?php echo $product->product_s_desc ?>
								</div>
							<?php endif; ?>
						</dd>
						<dd class="hidden-xs align-right nowrap">
							<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency)); ?>
							<?php if($this->params->get('vm_wishlist_show_addtocart', 1)) : ?>
								<?php 
								$stockhandle = VmConfig::get('stockhandle_products', false) && property_exists($product, 'product_stockhandle') && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
								$costPrice   = (float) $product->prices['costPrice'];
								$salesPrice  = (float) $product->prices['salesPrice'];
								$tmpPrice    = !empty($costPrice) && !empty($salesPrice);
								$notify      = (property_exists($product, 'show_notify') && $product->show_notify) || (($stockhandle == 'disableit' || $stockhandle == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1);
								?>
								<?php if(empty($product->customfieldsSorted['addtocart']) || $notify) : ?>
									<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => true, 'listMode' => 'grid')); ?>
								<?php else : ?>
									<div class="addtocart-area">
										<a href="<?php echo $product->link; ?>" class="btn btn-invert btn-addtocart btn-md addtocart-button"><?php echo JText::_('TPL_VP_SMART_VIEW_OPTIONS') ?></a>
									</div>
								<?php endif; ?>
							<?php endif; ?>
						</dd>
						<dd class="width10 nowrap align-center">
							<form name="wishlistItem" method="post" action="<?php echo JRoute::_('index.php?option=com_ajax&plugin=vpframework&format=raw'); ?>" class="inline-form">
								<button type="submit" class="btn btn-transparent hasTooltip" title="<?php echo JText::_('JTRASH') ?>">
									<i class="fa fa-trash-o fa-lg" aria-hidden="true"></i>
									<span class="sr-only"><?php echo JText::_('JTRASH') ?></span>
								</button>
								<input type="hidden" name="component" value="com_ajax" />
								<input type="hidden" name="plugin" value="vpframework" />
								<input type="hidden" name="format" value="raw" />
								<input type="hidden" name="vpfmethod" value="removeFromWishlist" />
								<input type="hidden" name="product_id" value="<?php echo $product->virtuemart_product_id ?>" />
								<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name) ?>" />
								<input type="hidden" name="return" value="<?php echo base64_encode(JUri::current()) ?>" />
								<?php echo JHTML::_('form.token'); ?>
							</form>
						</dd>
					</dl>
				</li>
			<?php endforeach; ?>
		<?php endif; ?>
	</ul>
</div>
<?php echo vmJsApi::writeJS(); ?>