<?php
/**
 * @package    VirtueMart Essentials
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Initialize some variables
$app       = JFactory::getApplication();
$product   = isset($displayData['product']) ? $displayData['product'] : null;
$iconOnly  = isset($displayData['iconOnly']) ? $displayData['iconOnly'] : false;
$isAdded   = isset($displayData['isAdded']) ? $displayData['isAdded'] : false;
$params    = isset($displayData['params']) ? $displayData['params'] : $app->getParams('com_vmessentials');
$url       = isset($displayData['url']) ? $displayData['url'] : null;
$iconClass = isset($displayData['iconClass']) ? $displayData['iconClass'] : '';
$btnClass  = isset($displayData['btnClass']) ? $displayData['btnClass'] : '';
$dataAjax  = $params->get('ajax_compare', 1) ? ' data-vmecompare' : '';
?>
<a href="<?php echo $url ?>" class="btn-vme btn-item-added vme-compare-link hasTooltip <?php echo $btnClass; ?><?php echo !$isAdded ? ' vme-hide' : ''; ?>" title="<?php echo JText::_('COM_VMESSENTIALS_GO_TO_COMPARE'); ?>" data-vmeid="<?php echo (int) $product->virtuemart_product_id; ?>" target="_top">
	<?php if(!empty($iconClass)) : ?>
		<i class="<?php echo $iconClass ?>"></i>
	<?php endif; ?>
	<?php if(!$iconOnly) : ?>
		<span><?php echo JText::_('COM_VMESSENTIALS_GO_TO_COMPARE'); ?></span>
	<?php endif; ?>
</a>
<form action="<?php echo $url ?>" method="post" class="vmessentials-form vmessentials-compare-form<?php echo !$isAdded ? '' : ' vme-hide'; ?>">
	<button type="submit" class="btn-vme hasTooltip <?php echo $btnClass ?>" title="<?php echo JText::_('COM_VMESSENTIALS_ADD_TO_COMPARE'); ?>"<?php echo $dataAjax; ?>>
		<?php if(!empty($iconClass)) : ?>
			<i class="<?php echo $iconClass ?>"></i>
		<?php endif; ?>
		<?php if(!$iconOnly) : ?>
			<span><?php echo JText::_('COM_VMESSENTIALS_ADD_TO_COMPARE'); ?></span>
		<?php endif; ?>
	</button>
	<input type="hidden" name="option" value="com_vmessentials" />
	<input type="hidden" name="task" value="compare.add" />
	<input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
	<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
	<?php echo JHtml::_('form.token'); ?>
	<?php echo JHtml::_('vmessentials.returnUri'); ?>
</form>