<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\CMS\Helper\AuthenticationHelper;

JHtml::_('behavior.formvalidator');

$params           = $displayData['params'];
$type             = VPFrameworkLogin::getType();
$return           = VPFrameworkLogin::getReturnURL($params, $type);
$twofactormethods = VPFrameworkLogin::getTwoFactorMethods();
$user             = JFactory::getUser();
$usersConfig      = JComponentHelper::getParams('com_users');
$extraButtons     = version_compare(JVERSION, '4.0.0', 'ge') ? AuthenticationHelper::getLoginButtons('vpf-modal-login-form') : array();
$srcUrl           = version_compare(JVERSION, '4.0.0', 'ge') ? JUri::root() : JUri::getInstance()->toString();
?>
<?php if ($type == 'login') : ?>
	<div class="boot-modal modal-narrow fade" id="vpf-modal-login-box" tabindex="-1" role="dialog" aria-labelledby="modalLoginLabel" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">
						<span aria-hidden="true">&times;</span><span class="sr-only"><?php echo JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></span>
					</button>
					<h4 class="modal-title"><?php echo JText::_('JLOGIN') ?></h4>
				</div>
				<form action="<?php echo JRoute::_($srcUrl, true, $params->get('usesecure')); ?>" method="post" id="vpf-modal-login-form" class="form-validate" role="form">
					<div class="modal-body">
						<?php if ($params->get('pretext')) : ?>
						<div class="pretext">
							<p><?php echo $params->get('pretext'); ?></p>
						</div>
						<?php endif; ?>
						<div class="alert alert-warning hide" role="alert"></div>
						<div class="form-group">
							<label for="modal-login-username" class="control-label"><?php echo JText::_('JGLOBAL_USERNAME'); ?></label>
							<input id="modal-login-username" type="text" name="username" class="form-control" size="25" required="true" autocomplete="username" />
						</div>
						<div class="form-group">
							<label for="modal-login-passwd" class="control-label"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label>
							<input id="modal-login-passwd" type="password" name="password" class="form-control" size="25" required="true" autocomplete="current-password" />
							<div class="field-hint"><a class="text-muted" href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>"><?php echo JText::_('COM_USERS_LOGIN_RESET'); ?></a></div>
						</div>
						<?php if (count($twofactormethods) > 1): ?>
						<div class="form-group">
							<label for="modal-login-secretkey" class="control-label"><?php echo JText::_('JGLOBAL_SECRETKEY'); ?></label>
							<div class="input-group">
								<input id="modal-login-secretkey" autocomplete="off" type="text" name="secretkey" class="form-control" size="18" />
								<span class="input-group-addon hasTooltip" title="<?php echo JText::_('JGLOBAL_SECRETKEY_HELP'); ?>"><i class="fa fa-info"></i></span>
							</div>
						</div>
						<?php endif; ?>
						<?php foreach ($extraButtons as $button):
							$dataAttributeKeys = array_filter(array_keys($button), function ($key) {
								return substr($key, 0, 5) == 'data-';
							});
							?>
							<div class="submission-buttons">
								<button type="button"
										class="btn btn-primary btn-block <?php echo $button['class'] ?? '' ?>"
										<?php foreach ($dataAttributeKeys as $key): ?>
										<?php echo $key ?>="<?php echo $button[$key] ?>"
										<?php endforeach; ?>
										<?php if ($button['onclick']): ?>
										onclick="<?php echo $button['onclick'] ?>"
										<?php endif; ?>
										title="<?php echo JText::_($button['label']) ?>"
										id="<?php echo $button['id'] ?>"
										>
									<?php if (!empty($button['icon'])): ?>
										<span class="<?php echo $button['icon'] ?>"></span>
									<?php elseif (!empty($button['image'])): ?>
										<?php echo $button['image']; ?>
									<?php elseif (!empty($button['svg'])): ?>
										<?php echo $button['svg']; ?>
									<?php endif; ?>
									<?php echo JText::_($button['label']) ?>
								</button>
							</div>
						<?php endforeach; ?>
						<div class="submission-buttons">
							<button type="submit" tabindex="0" name="Submit" class="btn btn-base btn-lg btn-wide"><?php echo JText::_('JLOGIN') ?></button>
  						<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
  							<div class="checkbox">
  								<label for="modal-login-remember">
  									<input id="modal-login-remember" type="checkbox" name="remember" value="yes"/>
  									<?php echo JText::_('COM_USERS_LOGIN_REMEMBER_ME') ?>
  								</label> 
  							</div>
  						<?php endif; ?>
						</div>
						<?php if ($params->get('posttext')) : ?>
							<div class="posttext">
								<p><?php echo $params->get('posttext'); ?></p>
							</div>
						<?php endif; ?>
					</div>
					<div class="modal-footer">
						<ul class="list-inline align-center">
  						<?php if ($usersConfig->get('allowUserRegistration')) : ?>
  						<li>
  							<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>"><?php echo JText::_('COM_USERS_LOGIN_REGISTER'); ?></a>
  						</li>
  						<?php endif; ?>
							<li>
								<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>"><?php echo JText::_('COM_USERS_LOGIN_REMIND'); ?></a>
							</li>
						</ul>
					</div>
					<input type="hidden" name="option" value="com_users" />
					<input type="hidden" name="task" value="user.login" />
					<input type="hidden" name="return" value="<?php echo $return; ?>" data-value="<?php echo htmlspecialchars($return); ?>" />
					<div data-token="dynamic">
						<?php echo JHtml::_('form.token'); ?>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php else : ?>
	<div id="vpf-modal-logout-box" class="hide">
		<form action="<?php echo JRoute::_($srcUrl, true, $params->get('usesecure')); ?>" method="post" id="vpf-modal-logout-form" class="form-vertical">
			<input type="hidden" name="logout_text" value="<?php echo JText::_('JLOGOUT'); ?>" />
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="task" value="user.logout" />
			<input type="hidden" name="return" value="<?php echo $return; ?>" />
			<div data-token="dynamic">
				<?php echo JHtml::_('form.token'); ?>
			</div>
		</form>
	</div>
<?php endif; ?>