<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

if (file_exists(JPATH_SITE . '/components/com_users/helpers/route.php'))
{
	require_once JPATH_SITE . '/components/com_users/helpers/route.php';
}

JHtml::_('behavior.keepalive');
JHtml::_('bootstrap.tooltip');
?>
<form action="<?php echo JRoute::_(JUri::getInstance()->toString(), true, $params->get('usesecure')); ?>" method="post" id="<?php echo isset($formId) ? $formId : 'mod-login-form'; ?>">
	<?php if ($params->get('pretext')) : ?>
		<div class="pretext">
			<p><?php echo $params->get('pretext'); ?></p>
		</div>
	<?php endif; ?>
	<div class="userdata">
		<div id="form-login-username" class="form-group">
			<?php if (!$params->get('usetext')) : ?>
				<label class="sr-only" for="modlgn-username"><?php echo JText::_('MOD_LOGIN_VALUE_USERNAME'); ?></label>
				<div class="input-group">
					<div class="input-group-addon hasTooltip" title="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>">
						<i class="fa fa-user"></i>
					</div>
					<input type="text" id="modlgn-username" name="username" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>"/>
				</div>
			<?php else: ?>
				<label for="modlgn-username"><?php echo JText::_('MOD_LOGIN_VALUE_USERNAME'); ?></label>
				<input type="text" id="modlgn-username" name="username" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>"/>
			<?php endif; ?>
		</div>
		<div id="form-login-password" class="form-group">
			<?php if (!$params->get('usetext')) : ?>
				<label class="sr-only" for="modlgn-passwd"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label>
				<div class="input-group">
					<div class="input-group-addon hasTooltip" title="<?php echo JText::_('JGLOBAL_PASSWORD') ?>">
						<i class="fa fa-lock"></i>
					</div>
					<input type="password" id="modlgn-passwd" name="password" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>"/>
				</div>
			<?php else: ?>
				<label for="modlgn-passwd"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label>
				<input id="modlgn-passwd" type="password" name="password" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>" />
			<?php endif; ?>
		</div>
		<?php if (isset($twofactormethods) && is_array($twofactormethods) && count($twofactormethods) > 1) : ?>
			<div id="form-login-secretkey" class="form-group">
				<?php if (!$params->get('usetext')) : ?>
					<label class="sr-only" for="modlgn-secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY'); ?></label>
					<div class="input-group">
						<div class="input-group-addon hasTooltip" title="<?php echo JText::_('JGLOBAL_SECRETKEY'); ?>">
							<i class="fa fa-star"></i>
						</div>
						<input type="text" id="modlgn-secretkey" autocomplete="off" name="secretkey" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY'); ?>"/>
						<div class="input-group-addon hasTooltip" title="<?php echo JText::_('JGLOBAL_SECRETKEY_HELP'); ?>"><i class="fa fa-info"></i></div>
					</div>
				<?php else: ?>
					<label for="modlgn-secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY') ?></label>
					<input type="text" id="modlgn-secretkey" autocomplete="off" name="secretkey" class="form-control" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY'); ?>"/>
					<span class="btn btn-default btn-sm hasTooltip" title="<?php echo JText::_('JGLOBAL_SECRETKEY_HELP'); ?>"><i class="fa fa-info"></i></span>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
			<div id="form-login-remember" class="checkbox">
				<label for="modlgn-remember">
					<input type="checkbox" id="modlgn-remember" name="remember" value="yes">&nbsp;&nbsp;<span class="checkbox-text"><?php echo JText::_('MOD_LOGIN_REMEMBER_ME'); ?></span>
				</label>
			</div>
		<?php endif; ?>
		
		<?php if (isset($extraButtons)) : ?>
			<?php foreach($extraButtons as $button):
				$dataAttributeKeys = array_filter(array_keys($button), function ($key) {
					return substr($key, 0, 5) == 'data-';
				});
				?>
				<div class="mod-login__submit form-group">
					<button type="button"
							class="btn btn-default btn-block mt-2 <?php echo $button['class'] ?? '' ?>"
							<?php foreach ($dataAttributeKeys as $key): ?>
							<?php echo $key ?>="<?php echo $button[$key] ?>"
							<?php endforeach; ?>
							<?php if ($button['onclick']): ?>
							onclick="<?php echo $button['onclick'] ?>"
							<?php endif; ?>
							title="<?php echo JText::_($button['label']) ?>"
							id="<?php echo $button['id'] ?>"
							>
						<?php if (!empty($button['icon'])): ?>
							<span class="<?php echo $button['icon'] ?>"></span>
						<?php elseif (!empty($button['image'])): ?>
							<?php echo $button['image']; ?>
						<?php elseif (!empty($button['svg'])): ?>
							<?php echo $button['svg']; ?>
						<?php endif; ?>
						<?php echo JText::_($button['label']) ?>
					</button>
				</div>
			<?php endforeach; ?>
		<?php endif; ?>
		
		<button type="submit" tabindex="0" name="Submit" class="btn btn-default"><?php echo JText::_('JLOGIN') ?></button>
		<?php $usersConfig = JComponentHelper::getParams('com_users'); ?>
		<?php if (class_exists('UsersHelperRoute')) : ?>
			<ul class="list-unstyled">
				<?php if ($usersConfig->get('allowUserRegistration')) : ?>
					<li>
						<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration&Itemid=' . UsersHelperRoute::getRegistrationRoute()); ?>"><?php echo JText::_('MOD_LOGIN_REGISTER'); ?></a>
					</li>
				<?php endif; ?>
				<li>
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind&Itemid=' . UsersHelperRoute::getRemindRoute()); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_USERNAME'); ?></a>
				</li>
				<li>
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset&Itemid=' . UsersHelperRoute::getResetRoute()); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_PASSWORD'); ?></a>
				</li>
			</ul>
		<?php else : ?>
			<ul class="list-unstyled">
				<?php if ($usersConfig->get('allowUserRegistration')) : ?>
					<li>
						<a href="<?php echo isset($registerLink) ? JRoute::_($registerLink) : JRoute::_('index.php?option=com_users&view=registration'); ?>"><?php echo JText::_('MOD_LOGIN_REGISTER'); ?></a>
					</li>
				<?php endif; ?>
				<li>
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_USERNAME'); ?></a>
				</li>
				<li>
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>"><?php echo JText::_('MOD_LOGIN_FORGOT_YOUR_PASSWORD'); ?></a>
				</li>
			</ul>
		<?php endif; ?>
		<input type="hidden" name="option" value="com_users" />
		<input type="hidden" name="task" value="user.login" />
		<input type="hidden" name="return" value="<?php echo $return; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<?php if ($params->get('posttext')) : ?>
		<div class="posttext">
			<p><?php echo $params->get('posttext'); ?></p>
		</div>
	<?php endif; ?>
</form>
