<?php 
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$list = VPFrameworkVM::getCurrencies();
?>
<div class="topbar-switch">
	<form action="<?php echo vmURI::getCleanUrl() ?>" method="post">
		<span class="topbar-switch-inner">
			<?php if(!empty($text_before)) : ?>
				<span class="text-muted"><?php echo $text_before ?>:</span>
			<?php endif; ?>
			<?php echo $text_before; ?>
			<?php if($module->showtitle) : ?>
				<span class="text-muted"><?php echo $module->title ?>:</span>
			<?php endif; ?>
			<?php if(isset($list[$virtuemart_currency_id])) : ?>
				<span class="topbar-switch-selected"><?php echo $list[$virtuemart_currency_id]->currency_code_3 ?></span>
				<span class="fa fa-angle-down"></span>
			<?php endif; ?>
		</span>	
		<ul class="topbar-switch-list">
			<?php foreach($currencies as $currency) : ?>
				<?php if(isset($list[$currency->virtuemart_currency_id])) : ?>
					<?php 
					$currency_code_3 = $list[$currency->virtuemart_currency_id]->currency_code_3;
					$currency_name =  $list[$currency->virtuemart_currency_id]->currency_name; 
					?>
					<li<?php if($currency->virtuemart_currency_id == $virtuemart_currency_id) echo ' class="active"'; ?>>
						<a href="#<?php echo $currency_code_3 ?>" class="select-me" data-id="<?php echo $currency->virtuemart_currency_id ?>"><?php echo $currency_code_3 ?> - <?php echo $currency_name ?></a>
					</li>
				<?php endif; ?>
			<?php endforeach; ?>
		</ul>
		<input type="hidden" name="virtuemart_currency_id" class="topbar-switch-id" value="<?php echo $virtuemart_currency_id ?>" />
	</form>
</div>