<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$app    = JFactory::getApplication();
$input  = $app->input;
$ajax   = 1;
$option = $app->getUserState('mod_vp_mini_cart.option', '');
$view   = $app->getUserState('mod_vp_mini_cart.view', '');

if($input->getCmd('option') != 'com_ajax')
{
	$option = $app->getUserStateFromRequest('mod_vp_mini_cart.option', 'option', null, 'CMD');
	$view   = $app->getUserStateFromRequest('mod_vp_mini_cart.view', 'view', null, 'CMD');
}

if($option == 'com_virtuemart' && $view == 'cart')
{
	$ajax = 0;
}
$i = 0;

VPFrameworkScript::addOption('vp_minicart_module_class', VPFrameworkScript::cleanClass('vp-minicart' . $moduleclass_sfx));
?>
<div class="vp-minicart<?php echo $moduleclass_sfx ?>">
	<div class="vp-dropmod-container">
		<div class="vp-dropmod-anchor btn-jewel-group">
			<a href="<?php echo !empty($cart_url) ? $cart_url : '#'; ?>" class="color-base <?php echo empty($product_count) ? 'empty' : 'has-item'; ?>">
				<i class="fa fa-smart-cart-o fa-2x"></i>
			</a>
			<div class="jewel jewel-top jewel-invert<?php echo empty($product_count) ? ' hide' : ''; ?>">
				<span class="product-count"><?php echo (int) $product_count ?></span>
			</div>
		</div>
		<span class="mini-cart-total"><?php echo $currencyDisplay->priceDisplay($cart->cartPrices['billTotal']); ?></span>
		<div class="vp-dropmod-inner">
			<div class="vp-dropmod-contents">
				<?php if(empty($unique_product_count)) : ?>
					<div class="vp-dropmod-header empty">
						<div class="row row-mini">
							<div class="col-xs-12 align-center">
								<?php echo vmText::_('COM_VIRTUEMART_CART_NO_PRODUCT') ?>
							</div>
						</div>
					</div>
				<?php else : ?>
					<div class="vp-dropmod-header">
						<div class="row row-mini">
							<div class="col-xs-12">
								<span class="product-count-text">
									<?php echo vmText::_('COM_VIRTUEMART_CART_TOTAL') . ': ' . $currencyDisplay->priceDisplay($cart->cartPrices['billTotal']); ?>
								</span>
								<a class="btn btn-sm btn-base pull-right" href="<?php echo $cart_url ?>" title="<?php echo $cartText ?>"><?php echo $cartText ?></a>
							</div>
						</div>
					</div>
					<?php foreach($cart->products as $pkey => $product) : ?>
						<?php $i++; ?>
						<div class="row row-mini product-row">
							<div class="col-xs-3">
								<a href="<?php echo $product->url ?>" class="product-thumbnail">
									<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
								</a>
							</div>
							<div class="col-xs-8">
								<span><?php echo $product->quantity ?></span><span aria-hidden="true">&nbsp;&times;&nbsp;</span><?php echo JHtml::link($product->url, $product->product_name, 'class="mod-product-name hover-invert"') ?>
								<?php 
								$variants = $customfieldsModel->CustomsFieldCartDisplay($product);
								$temp = trim(strip_tags($variants)); ?>
								<?php if(!empty($temp)) : ?>
									<div class="product-varients">
										<?php $variants; ?>
									</div>
								<?php endif; ?>
								<?php if($params->get('show_price', 1) && $currencyDisplay->_priceConfig['salesPrice'][0]) : ?>
								<div class="mod-product-price">
									<?php echo $currencyDisplay->priceDisplay($product->allPrices[$product->selectedPrice]['subtotal_with_tax']); ?>
								</div>
								<?php endif; ?>
							</div>
							<div class="col-xs-1">
								<button type="button" class="close remove vpf-removefromcart-btn" data-productkey="<?php echo $pkey ?>" data-productname="<?php echo $product->product_name ?>" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?>" data-ajax="<?php echo (int) $ajax ?>">
									<span aria-hidden="true">&times;</span><span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?></span>
								</button>
							</div>
						</div>
						<?php if($i < $unique_product_count) : ?>
							<div class="mod-row-separator"></div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
				<div class="vp-dropmod-loader hide"><div class="inner"></div></div>
			</div>	
		</div>		
	</div>
</div>

