<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
?>
<ul class="nav navbar-nav vpf-menu"<?php
	$tag = '';

	if ($params->get('tag_id') != null)
	{
		$tag = $params->get('tag_id') . '';
		echo ' id="' . $tag . '"';
	}
?> data-animate="<?php echo $this->params->get('mega_animation', 'fade') ?>" data-easing-open="<?php echo $this->params->get('mega_easing_open', 'linear') ?>" data-easing-close="<?php echo $this->params->get('mega_easing_close', 'linear') ?>" data-easing-time="<?php echo (int) $this->params->get('mega_easing_time', 100) ?>">
<?php 
foreach ($list as $i => &$item)
{
	$class      = '';
	$itemParams = method_exists($item, 'getParams') ? $item->getParams() : $item->params;
	
	if($item->type != 'vmcategory' && $item->type != 'module')
	{
		$class .= 'menuitem item-' . $item->id;
	}
	elseif($item->type == 'vmcategory')
	{
		$class .= 'vmcategory vmcat-' . $item->virtuemart_category_id;
	}
	
	$class .= ' level-' . $item->level;
	
	$class .= ($item->level > 1) ? ' submenu' : '';
	

	if (($item->id == $active_id) OR ($item->type == 'alias' AND $itemParams->get('aliasoptions') == $active_id))
	{
		$class .= ' active';
	}
	if(in_array($item->id, $path))
	{
		$class .= ' active';
	}
	elseif ($item->type == 'alias')
	{
		$aliasToId = $itemParams->get('aliasoptions');

		if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
		{
			$class .= ' active';
		}
		elseif (in_array($aliasToId, $path))
		{
			$class .= ' alias-parent-active';
		}
	}
	elseif($item->type == 'vmcategory')
	{
		if($item->active)
		{
			$class .= ' active';
		}
	}

	if ($item->type == 'separator')
	{
		$class .= ' divider';
	}

	if ($item->deeper)
	{
		$class .= ' deeper';
	}

	if ($item->parent)
	{
		$class .= ' parent';
		$class .= $item->group ? ' mega-group' : ' mega-expand';
	}
	
	if(isset($item->subwidth) && !empty($item->subwidth))
	{
		$class .= ' col-xs-' . $item->subwidth;
	}
	
	if (!empty($class))
	{
		$class = ' class="' . trim($class) . '"';
	}
	
	if($item->type != 'module')
	{
		echo '<li' . $class . '>';
	}	

	// Render the menu item.
	switch ($item->type) :
		case 'separator':
		case 'url':
		case 'component':
		case 'module':
		case 'vmcategory':
		case 'heading':
			require $this->getMenuLayout('default_' . $item->type);
			break;

		default:
			require $this->getMenuLayout('default_url');
			break;
	endswitch;
	
	// The next item is deeper.
	if ($item->deeper)
	{
		$subClass = array();
		if($item->mega_class)
		{
			$subClass[] = $item->mega_class;
		}
		$subClass[] = $item->group ? 'mega-menu-group' : 'mega-menu-expand';
		$subClass = ' ' . implode(' ', $subClass);
				
		echo '<div class="mega-sub-cont' . $subClass . '" data-megamenu-width="' . $item->width . '">';
	
		echo '<ul class="row row-condensed">';
	}
	elseif ($item->shallower)
	{
		// The next item is shallower.
			if($item->type != 'module')
			{
				echo '</li>';
			}			
			echo str_repeat('</ul></div></li>', $item->level_diff);
	}
	elseif($item->type != 'module')
	{
		// The next item is on the same level.
		echo '</li>';
	}
}
?></ul>
