<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.
$class         = $item->anchor_css ? 'class="' . $item->anchor_css . '" ' : '';
$title         = $item->anchor_title ? 'title="' . $item->anchor_title . '" ' : '';
$itemParams    = method_exists($item, 'getParams') ? $item->getParams() : $item->params;
$description   = trim($itemParams->get('mega_desc', ''));
$sticker       = trim($itemParams->get('mega_sticky_text', ''));
$sticker_style = $itemParams->get('mega_sticky_style', 'grey');
$sticker       = !empty($sticker) ? '<span class="sticker sticker-' . $sticker_style . '">' . $sticker . '</span>' : '';
$icon          = $itemParams->get('mega_icon_class', '');

if ($icon)
{
	if ($itemParams->get('menu_text', 1))
	{
		if ($itemParams->get('mega_showdesc', 1) && !empty($description))
		{
			$linktype = '<span class="menu-group with-icon with-description"><span class="menu-image"><i class="' . $icon . '"></i></span><span class="image-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
		}
		else
		{
			$linktype = '<span class="menu-group with-icon"><span class="menu-image"><i class="' . $icon . '"></i></span><span class="image-title">' . $item->title . '</span>' . $sticker . '</span>';
		}
	}
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-image"><i class="' . $icon . '"></i></span>' . $sticker . '</span>';
	}
}
elseif ($item->menu_image)
{
	if ($itemParams->get('menu_text', 1))
	{
		if ($itemParams->get('mega_showdesc', 1) && !empty($description))
		{
			$linktype = '<span class="menu-group with-image with-description"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span><span class="image-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
		}
		else
		{
			$linktype = '<span class="menu-group with-image"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span><span class="image-title">' . $item->title . '</span>' . $sticker . '</span>';
		}
	}
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-image"><img src="' . $item->menu_image . '" alt="' . $item->title . '" /></span>' . $sticker . '</span>';
	}
}
else
{
	if ($itemParams->get('mega_showdesc', 1) && !empty($description))
	{
		$linktype = '<span class="menu-group with-description"><span class="menu-title">' . $item->title . '</span>' . $sticker . '<span class="menu-desc">' . $description . '</span></span>';
	}	
	else
	{
		$linktype = '<span class="menu-group"><span class="menu-title">' . $item->title . '</span>' . $sticker . '</span>';
	}
}

$flink = $item->flink;
$flink = JFilterOutput::ampReplace(htmlspecialchars($flink));

switch ($item->browserNav) :
	default:
	case 0:
?><a <?php echo $class; ?>href="<?php echo $flink; ?>" <?php echo $title; ?>><?php echo $linktype; ?></a><?php
		break;
	case 1:
		// _blank
?><a <?php echo $class; ?>href="<?php echo $flink; ?>" target="_blank" <?php echo $title; ?>><?php echo $linktype; ?></a><?php
		break;
	case 2:
		// Use JavaScript "window.open"
		$options = 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,' . $params->get('window_open');
			?><a <?php echo $class; ?>href="<?php echo $flink; ?>" onclick="window.open(this.href,'targetWindow','<?php echo $options;?>');return false;" <?php echo $title; ?>><?php echo $linktype; ?></a><?php
		break;
endswitch;
