<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$template         = plgSystemVPFrameworkHelper::getTemplate();
$app              = JFactory::getApplication();
$doc              = JFactory::getDocument();
$browser          = VPFrameworkBrowser::getInstance();
$tab              = $doc->_getTab();
$lineEnd          = $doc->_getLineEnd();
$user             = JFactory::getUser();
$this->language   = $doc->language;
$this->direction  = $doc->direction;
$params           = $template->params;
$this->params     = $params;
$version          = !empty($template->xml->version) ? $template->xml->version : 'unknown';

// Detecting Active Variables
$option           = $app->input->getCmd('option', '');
$view             = $app->input->getCmd('view', '');
$layout           = $app->input->getCmd('layout', '');
$task             = $app->input->getCmd('task', '');
$print            = $app->input->getInt('print', 0);
$itemid           = $app->input->getInt('Itemid', '');
$tmpl             = $app->input->getCmd('tmpl', '');
$sitename         = $app->get('sitename');
$responsive       = $params->get('responsive', 1);

$htmlClass        = ($responsive ? 'responsive' : 'unresponsive') .
                    ($option ? ' ' . str_replace('_', '-', $option) : '') .
                    ($view ? ' view-' . $view : ' no-view') .
                    ($layout ? ' layout-' . $layout : ' no-layout') .
                    ($task ? ' task-' . $task : ' no-task') . 
                    ($tmpl ? ' tmpl-' . $tmpl : '') .
                    ($itemid ? ' itemid-' . $itemid : '');

require $template->getStructure(__FILE__);